/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.ConversionRecipe;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.GhostIngredientHandler;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.PotionFluidSubtypeInterpreter;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.ToolboxColoringRecipeMaker;
import com.simibubi.create.compat.jei.category.BlockCuttingCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.CrushingCategory;
import com.simibubi.create.compat.jei.category.DeployingCategory;
import com.simibubi.create.compat.jei.category.FanBlastingCategory;
import com.simibubi.create.compat.jei.category.FanHauntingCategory;
import com.simibubi.create.compat.jei.category.FanSmokingCategory;
import com.simibubi.create.compat.jei.category.FanWashingCategory;
import com.simibubi.create.compat.jei.category.ItemApplicationCategory;
import com.simibubi.create.compat.jei.category.ItemDrainCategory;
import com.simibubi.create.compat.jei.category.MechanicalCraftingCategory;
import com.simibubi.create.compat.jei.category.MillingCategory;
import com.simibubi.create.compat.jei.category.MixingCategory;
import com.simibubi.create.compat.jei.category.MysteriousItemConversionCategory;
import com.simibubi.create.compat.jei.category.PackingCategory;
import com.simibubi.create.compat.jei.category.PolishingCategory;
import com.simibubi.create.compat.jei.category.PressingCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.compat.jei.category.SawingCategory;
import com.simibubi.create.compat.jei.category.SequencedAssemblyCategory;
import com.simibubi.create.compat.jei.category.SpoutCategory;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.contraptions.components.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.contraptions.components.deployer.ManualApplicationRecipe;
import com.simibubi.create.content.contraptions.components.fan.HauntingRecipe;
import com.simibubi.create.content.contraptions.components.fan.SplashingRecipe;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.components.press.PressingRecipe;
import com.simibubi.create.content.contraptions.components.saw.CuttingRecipe;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.fluids.actors.FillingRecipe;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluid;
import com.simibubi.create.content.contraptions.fluids.recipe.PotionMixingRecipes;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.EmptyingRecipe;
import com.simibubi.create.content.contraptions.processing.ItemApplicationRecipe;
import com.simibubi.create.content.curiosities.tools.BlueprintScreen;
import com.simibubi.create.content.curiosities.tools.SandPaperPolishingRecipe;
import com.simibubi.create.content.logistics.item.LinkedControllerScreen;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleScreen;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CRecipes;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.data.recipe.LogStrippingFakeRecipes;
import com.simibubi.create.foundation.gui.container.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.ModList;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CreateJEI
implements IModPlugin {
    private static final ResourceLocation ID = Create.asResource("jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory<AbstractCrushingRecipe> milling = this.builder(AbstractCrushingRecipe.class).addTypedRecipes(AllRecipeTypes.MILLING).catalyst(() -> AllBlocks.MILLSTONE.get()).doubleItemIcon((ItemLike)AllBlocks.MILLSTONE.get(), (ItemLike)AllItems.WHEAT_FLOUR.get()).emptyBackground(177, 53).build("milling", MillingCategory::new);
        CreateRecipeCategory crushing = this.builder(AbstractCrushingRecipe.class).addTypedRecipes(AllRecipeTypes.CRUSHING).addTypedRecipesExcluding(AllRecipeTypes.MILLING::getType, AllRecipeTypes.CRUSHING::getType).catalyst(() -> AllBlocks.CRUSHING_WHEEL.get()).doubleItemIcon((ItemLike)AllBlocks.CRUSHING_WHEEL.get(), (ItemLike)AllItems.CRUSHED_GOLD.get()).emptyBackground(177, 100).build("crushing", CrushingCategory::new);
        CreateRecipeCategory<PressingRecipe> pressing = this.builder(PressingRecipe.class).addTypedRecipes(AllRecipeTypes.PRESSING).catalyst(() -> AllBlocks.MECHANICAL_PRESS.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_PRESS.get(), (ItemLike)AllItems.IRON_SHEET.get()).emptyBackground(177, 70).build("pressing", PressingCategory::new);
        CreateRecipeCategory<SplashingRecipe> washing = this.builder(SplashingRecipe.class).addTypedRecipes(AllRecipeTypes.SPLASHING).catalystStack(ProcessingViaFanCategory.getFan("fan_washing")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42447_).emptyBackground(178, 72).build("fan_washing", FanWashingCategory::new);
        CreateRecipeCategory smoking = this.builder(SmokingRecipe.class).addTypedRecipes(() -> net.minecraft.world.item.crafting.RecipeType.f_44110_).catalystStack(ProcessingViaFanCategory.getFan("fan_smoking")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42781_).emptyBackground(178, 72).build("fan_smoking", FanSmokingCategory::new);
        CreateRecipeCategory blasting = this.builder(AbstractCookingRecipe.class).addTypedRecipesExcluding(() -> net.minecraft.world.item.crafting.RecipeType.f_44108_, () -> net.minecraft.world.item.crafting.RecipeType.f_44109_).addTypedRecipes(() -> net.minecraft.world.item.crafting.RecipeType.f_44109_).removeRecipes(() -> net.minecraft.world.item.crafting.RecipeType.f_44110_).catalystStack(ProcessingViaFanCategory.getFan("fan_blasting")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42448_).emptyBackground(178, 72).build("fan_blasting", FanBlastingCategory::new);
        CreateRecipeCategory<HauntingRecipe> haunting = this.builder(HauntingRecipe.class).addTypedRecipes(AllRecipeTypes.HAUNTING).catalystStack(ProcessingViaFanCategory.getFan("fan_haunting")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42782_).emptyBackground(178, 72).build("fan_haunting", FanHauntingCategory::new);
        CreateRecipeCategory<BasinRecipe> mixing = this.builder(BasinRecipe.class).addTypedRecipes(AllRecipeTypes.MIXING).catalyst(() -> AllBlocks.MECHANICAL_MIXER.get()).catalyst(() -> AllBlocks.BASIN.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_MIXER.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 103).build("mixing", MixingCategory::standard);
        CreateRecipeCategory<BasinRecipe> autoShapeless = this.builder(BasinRecipe.class).enableWhen(c -> c.allowShapelessInMixer).addAllRecipesIf(r -> r instanceof CraftingRecipe && !(r instanceof IShapedRecipe) && r.m_7527_().size() > 1 && !MechanicalPressTileEntity.canCompress(r) && !AllRecipeTypes.shouldIgnoreInAutomation(r), BasinRecipe::convertShapeless).catalyst(() -> AllBlocks.MECHANICAL_MIXER.get()).catalyst(() -> AllBlocks.BASIN.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_MIXER.get(), (ItemLike)Items.f_41960_).emptyBackground(177, 85).build("automatic_shapeless", MixingCategory::autoShapeless);
        CreateRecipeCategory brewing = this.builder(BasinRecipe.class).enableWhen(c -> c.allowBrewingInMixer).addRecipes(() -> PotionMixingRecipes.ALL).catalyst(() -> AllBlocks.MECHANICAL_MIXER.get()).catalyst(() -> AllBlocks.BASIN.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_MIXER.get(), (ItemLike)Blocks.f_50255_).emptyBackground(177, 103).build("automatic_brewing", MixingCategory::autoBrewing);
        CreateRecipeCategory<BasinRecipe> packing = this.builder(BasinRecipe.class).addTypedRecipes(AllRecipeTypes.COMPACTING).catalyst(() -> AllBlocks.MECHANICAL_PRESS.get()).catalyst(() -> AllBlocks.BASIN.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_PRESS.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 103).build("packing", PackingCategory::standard);
        CreateRecipeCategory<BasinRecipe> autoSquare = this.builder(BasinRecipe.class).enableWhen(c -> c.allowShapedSquareInPress).addAllRecipesIf(r -> r instanceof CraftingRecipe && !(r instanceof MechanicalCraftingRecipe) && MechanicalPressTileEntity.canCompress(r) && !AllRecipeTypes.shouldIgnoreInAutomation(r), BasinRecipe::convertShapeless).catalyst(() -> AllBlocks.MECHANICAL_PRESS.get()).catalyst(() -> AllBlocks.BASIN.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_PRESS.get(), (ItemLike)Blocks.f_50091_).emptyBackground(177, 85).build("automatic_packing", PackingCategory::autoSquare);
        CreateRecipeCategory<CuttingRecipe> sawing = this.builder(CuttingRecipe.class).addTypedRecipes(AllRecipeTypes.CUTTING).catalyst(() -> AllBlocks.MECHANICAL_SAW.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_SAW.get(), (ItemLike)Items.f_41837_).emptyBackground(177, 70).build("sawing", SawingCategory::new);
        CreateRecipeCategory blockCutting = this.builder(BlockCuttingCategory.CondensedBlockCuttingRecipe.class).enableWhen(c -> c.allowStonecuttingOnSaw).addRecipes(() -> BlockCuttingCategory.CondensedBlockCuttingRecipe.condenseRecipes(CreateJEI.getTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType.f_44112_, AllRecipeTypes::shouldIgnoreInAutomation))).catalyst(() -> AllBlocks.MECHANICAL_SAW.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_SAW.get(), (ItemLike)Items.f_42092_).emptyBackground(177, 70).build("block_cutting", BlockCuttingCategory::new);
        CreateRecipeCategory woodCutting = this.builder(BlockCuttingCategory.CondensedBlockCuttingRecipe.class).enableIf(c -> (Boolean)c.allowWoodcuttingOnSaw.get() != false && ModList.get().isLoaded("druidcraft")).addRecipes(() -> BlockCuttingCategory.CondensedBlockCuttingRecipe.condenseRecipes(CreateJEI.getTypedRecipesExcluding(SawTileEntity.woodcuttingRecipeType.get(), AllRecipeTypes::shouldIgnoreInAutomation))).catalyst(() -> AllBlocks.MECHANICAL_SAW.get()).doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_SAW.get(), (ItemLike)Items.f_42008_).emptyBackground(177, 70).build("wood_cutting", BlockCuttingCategory::new);
        CreateRecipeCategory<SandPaperPolishingRecipe> polishing = this.builder(SandPaperPolishingRecipe.class).addTypedRecipes(AllRecipeTypes.SANDPAPER_POLISHING).catalyst(() -> AllItems.SAND_PAPER.get()).catalyst(() -> AllItems.RED_SAND_PAPER.get()).itemIcon((ItemLike)AllItems.SAND_PAPER.get()).emptyBackground(177, 55).build("sandpaper_polishing", PolishingCategory::new);
        CreateRecipeCategory item_application = this.builder(ItemApplicationRecipe.class).addTypedRecipes(AllRecipeTypes.ITEM_APPLICATION).addRecipes(LogStrippingFakeRecipes::createRecipes).itemIcon((ItemLike)AllItems.BRASS_HAND.get()).emptyBackground(177, 60).build("item_application", ItemApplicationCategory::new);
        CreateRecipeCategory<DeployerApplicationRecipe> deploying = this.builder(DeployerApplicationRecipe.class).addTypedRecipes(AllRecipeTypes.DEPLOYING).addTypedRecipes(AllRecipeTypes.SANDPAPER_POLISHING::getType, DeployerApplicationRecipe::convert).addTypedRecipes(AllRecipeTypes.ITEM_APPLICATION::getType, ManualApplicationRecipe::asDeploying).catalyst(() -> AllBlocks.DEPLOYER.get()).catalyst(() -> AllBlocks.DEPOT.get()).catalyst(() -> AllItems.BELT_CONNECTOR.get()).itemIcon((ItemLike)AllBlocks.DEPLOYER.get()).emptyBackground(177, 70).build("deploying", DeployingCategory::new);
        CreateRecipeCategory<FillingRecipe> spoutFilling = this.builder(FillingRecipe.class).addTypedRecipes(AllRecipeTypes.FILLING).addRecipeListConsumer(recipes -> SpoutCategory.consumeRecipes(recipes::add, this.ingredientManager)).catalyst(() -> AllBlocks.SPOUT.get()).doubleItemIcon((ItemLike)AllBlocks.SPOUT.get(), (ItemLike)Items.f_42447_).emptyBackground(177, 70).build("spout_filling", SpoutCategory::new);
        CreateRecipeCategory<EmptyingRecipe> draining = this.builder(EmptyingRecipe.class).addRecipeListConsumer(recipes -> ItemDrainCategory.consumeRecipes(recipes::add, this.ingredientManager)).addTypedRecipes(AllRecipeTypes.EMPTYING).catalyst(() -> AllBlocks.ITEM_DRAIN.get()).doubleItemIcon((ItemLike)AllBlocks.ITEM_DRAIN.get(), (ItemLike)Items.f_42447_).emptyBackground(177, 50).build("draining", ItemDrainCategory::new);
        CreateRecipeCategory autoShaped = this.builder(CraftingRecipe.class).enableWhen(c -> c.allowRegularCraftingInCrafter).addAllRecipesIf(r -> r instanceof CraftingRecipe && !(r instanceof IShapedRecipe) && r.m_7527_().size() == 1 && !AllRecipeTypes.shouldIgnoreInAutomation(r)).addTypedRecipesIf(() -> net.minecraft.world.item.crafting.RecipeType.f_44107_, recipe -> recipe instanceof IShapedRecipe && !AllRecipeTypes.shouldIgnoreInAutomation(recipe)).catalyst(() -> AllBlocks.MECHANICAL_CRAFTER.get()).itemIcon((ItemLike)AllBlocks.MECHANICAL_CRAFTER.get()).emptyBackground(177, 107).build("automatic_shaped", MechanicalCraftingCategory::new);
        CreateRecipeCategory<CraftingRecipe> mechanicalCrafting = this.builder(CraftingRecipe.class).addTypedRecipes(AllRecipeTypes.MECHANICAL_CRAFTING).catalyst(() -> AllBlocks.MECHANICAL_CRAFTER.get()).itemIcon((ItemLike)AllBlocks.MECHANICAL_CRAFTER.get()).emptyBackground(177, 107).build("mechanical_crafting", MechanicalCraftingCategory::new);
        CreateRecipeCategory<SequencedAssemblyRecipe> seqAssembly = this.builder(SequencedAssemblyRecipe.class).addTypedRecipes(AllRecipeTypes.SEQUENCED_ASSEMBLY).itemIcon((ItemLike)AllItems.PRECISION_MECHANISM.get()).emptyBackground(180, 115).build("sequenced_assembly", SequencedAssemblyCategory::new);
        CreateRecipeCategory mysteryConversion = this.builder(ConversionRecipe.class).addRecipes(() -> MysteriousItemConversionCategory.RECIPES).itemIcon((ItemLike)AllBlocks.PECULIAR_BELL.get()).emptyBackground(177, 50).build("mystery_conversion", MysteriousItemConversionCategory::new);
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
        registration.addRecipes(RecipeTypes.CRAFTING, ToolboxColoringRecipeMaker.createRecipes().toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
    }

    public void registerFluidSubtypes(ISubtypeRegistration registration) {
        PotionFluidSubtypeInterpreter interpreter = new PotionFluidSubtypeInterpreter();
        PotionFluid potionFluid = (PotionFluid)AllFluids.POTION.get();
        registration.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)potionFluid.m_5613_(), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(ForgeTypes.FLUID_STACK, (Object)potionFluid.m_5615_(), (IIngredientSubtypeInterpreter)interpreter);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSimiContainerScreen.class, (IGuiContainerHandler)new SlotMover());
        registration.addGhostIngredientHandler(AbstractFilterScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(BlueprintScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(LinkedControllerScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(ScheduleScreen.class, new GhostIngredientHandler());
    }

    public static void consumeAllRecipes(Consumer<Recipe<?>> consumer) {
        Minecraft.m_91087_().m_91403_().m_105141_().m_44051_().forEach(consumer);
    }

    public static <T extends Recipe<?>> void consumeTypedRecipes(Consumer<T> consumer, net.minecraft.world.item.crafting.RecipeType<?> type) {
        Map map = (Map)Minecraft.m_91087_().m_91403_().m_105141_().f_44007_.get(type);
        if (map != null) {
            map.values().forEach(recipe -> consumer.accept(recipe));
        }
    }

    public static List<Recipe<?>> getTypedRecipes(net.minecraft.world.item.crafting.RecipeType<?> type) {
        ArrayList recipes = new ArrayList();
        CreateJEI.consumeTypedRecipes(recipes::add, type);
        return recipes;
    }

    public static List<Recipe<?>> getTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType<?> type, Predicate<Recipe<?>> exclusionPred) {
        List<Recipe<?>> recipes = CreateJEI.getTypedRecipes(type);
        recipes.removeIf(exclusionPred);
        return recipes;
    }

    public static boolean doInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
        if (recipe1.m_7527_().isEmpty() || recipe2.m_7527_().isEmpty()) {
            return false;
        }
        ItemStack[] matchingStacks = ((Ingredient)recipe1.m_7527_().get(0)).m_43908_();
        if (matchingStacks.length == 0) {
            return false;
        }
        return ((Ingredient)recipe2.m_7527_().get(0)).test(matchingStacks[0]);
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(recipeTypeEntry::getType);
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)excluded.get());
                CreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch(recipe, excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (net.minecraft.world.item.crafting.RecipeType)recipeType.get());
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)recipeType.get());
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch(recipe, excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon(new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon(new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background(new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List<Object>> recipesSupplier = this.predicate.test(AllConfigs.SERVER.recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : () -> Collections.emptyList();
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(Create.asResource(name), this.recipeClass), (Component)Lang.translateDirect("recipe." + name, new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory<T> category = factory.create(info);
            CreateJEI.this.allCategories.add(category);
            return category;
        }
    }
}

